/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.storage.user.dao;

import de.betoffice.storage.hibernate.AbstractCommonDao;
import de.betoffice.storage.user.UserDao;
import de.betoffice.storage.user.entity.Nickname;
import de.betoffice.storage.user.entity.User;
import jakarta.persistence.TypedQuery;
import java.util.List;
import java.util.Optional;
import org.hibernate.Session;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository(value="userDao")
public class UserDaoHibernate
extends AbstractCommonDao<User>
implements UserDao {
    private static final String QUERY_USER_BY_NICKNAME = "from " + User.class.getName() + " as user where user.nickname = :nickname";

    public UserDaoHibernate() {
        super(User.class);
    }

    private long countAll() {
        return (Long)this.getEntityManager().createQuery("select count(*) from Community c", Long.class).getSingleResult();
    }

    @Override
    public List<User> findAll() {
        return this.getEntityManager().createQuery("from User u", User.class).getResultList();
    }

    @Override
    public Page<User> findAll(String nicknameFilter, Pageable pageable) {
        long total = this.countAll();
        String filter = "%" + nicknameFilter + "%";
        List users = pageable.isPaged() ? ((Session)this.getEntityManager().unwrap(Session.class)).createQuery("from User u where LOWER(u.nickname) like LOWER(:filter)", User.class).setParameter("filter", (Object)filter).setFirstResult((int)pageable.getOffset()).setMaxResults(pageable.getPageSize()).getResultList() : ((Session)this.getEntityManager().unwrap(Session.class)).createQuery("from User u where LOWER(u.nickname) like LOWER(:filter)", User.class).setParameter("filter", (Object)filter).getResultList();
        return new PageImpl(users, pageable, total);
    }

    @Override
    public Optional<User> findByNickname(Nickname nickname) {
        TypedQuery user = this.getEntityManager().createQuery(QUERY_USER_BY_NICKNAME, User.class).setParameter("nickname", (Object)nickname);
        return UserDaoHibernate.singleResult(user);
    }

    @Override
    public Optional<User> findByChangeToken(String changeToken) {
        TypedQuery user = this.getEntityManager().createQuery("SELECT u FROM User u WHERE u.changeToken = :changeToken", User.class).setParameter("changeToken", (Object)changeToken);
        return UserDaoHibernate.singleResult(user);
    }
}

