/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.storage.season.entity;

import de.betoffice.storage.AbstractStorageObject;
import de.betoffice.storage.season.entity.GameList;
import de.betoffice.storage.season.entity.GameResult;
import de.betoffice.storage.season.entity.Goal;
import de.betoffice.storage.season.entity.Group;
import de.betoffice.storage.season.entity.Location;
import de.betoffice.storage.team.entity.Team;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Table;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.annotations.TimeZoneStorage;
import org.hibernate.annotations.TimeZoneStorageType;

@Entity
@Table(name="bo_game")
public class Game
extends AbstractStorageObject
implements Comparable<Game> {
    private static final long serialVersionUID = 8861153553430553696L;
    public static final String EMPTY = "";
    public static final int WIN = 3;
    public static final int LOST = 0;
    public static final int REMIS = 1;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id", updatable=false, nullable=false)
    private Long id;
    @Column(name="bo_datetime")
    @TimeZoneStorage(value=TimeZoneStorageType.NORMALIZE)
    private ZonedDateTime dateTime;
    @ManyToOne
    @JoinColumn(name="bo_group_ref")
    private Group group;
    @ManyToOne
    @JoinColumn(name="bo_hometeam_ref")
    private Team homeTeam;
    @ManyToOne
    @JoinColumn(name="bo_guestteam_ref")
    private Team guestTeam;
    @Column(name="bo_isplayed")
    private boolean played = false;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(column=@Column(name="bo_homegoals"), name="homeGoals"), @AttributeOverride(column=@Column(name="bo_guestgoals"), name="guestGoals")})
    private GameResult result = new GameResult();
    @AttributeOverrides(value={@AttributeOverride(column=@Column(name="bo_halftimehomegoals"), name="homeGoals"), @AttributeOverride(column=@Column(name="bo_halftimeguestgoals"), name="guestGoals")})
    private GameResult halfTimeGoals = new GameResult();
    @AttributeOverrides(value={@AttributeOverride(column=@Column(name="bo_overtimehomegoals"), name="homeGoals"), @AttributeOverride(column=@Column(name="bo_overtimeguestgoals"), name="guestGoals")})
    private GameResult overTimeGoals = new GameResult();
    @AttributeOverrides(value={@AttributeOverride(column=@Column(name="bo_penaltyhomegoals"), name="homeGoals"), @AttributeOverride(column=@Column(name="bo_penaltyguestgoals"), name="guestGoals")})
    private GameResult penaltyGoals = new GameResult();
    @ManyToOne
    @JoinColumn(name="bo_location_ref")
    private Location location;
    @Column(name="bo_index")
    private int index;
    @ManyToOne
    @JoinColumn(name="bo_gamelist_ref")
    private GameList gameList;
    @OneToMany(mappedBy="game")
    @OrderBy(value="bo_index")
    private List<Goal> goals = new ArrayList<Goal>();
    @Column(name="bo_openligaid")
    private Long openligaid;
    @Column(name="bo_ko")
    private boolean ko = false;

    @Override
    public Long getId() {
        return this.id;
    }

    protected void setId(Long value) {
        this.id = value;
    }

    public ZonedDateTime getDateTime() {
        return this.dateTime;
    }

    public void setDateTime(ZonedDateTime _dateTime) {
        this.dateTime = _dateTime;
    }

    public Group getGroup() {
        return this.group;
    }

    public void setGroup(Group value) {
        this.group = value;
    }

    public Team getHomeTeam() {
        return this.homeTeam;
    }

    public void setHomeTeam(Team value) {
        this.homeTeam = value;
    }

    public Team getGuestTeam() {
        return this.guestTeam;
    }

    public void setGuestTeam(Team value) {
        this.guestTeam = value;
    }

    public GameResult getResult() {
        return this.result;
    }

    public void setResult(GameResult value) {
        this.result = value;
    }

    public void setResult(int homeGoals, int guestGoals) {
        this.setResult(new GameResult(homeGoals, guestGoals));
    }

    public void setResult(int homeGoals, int guestGoals, boolean finished) {
        GameResult newValue = new GameResult(homeGoals, guestGoals);
        this.setResult(newValue);
        this.setPlayed(finished);
    }

    public GameResult getHalfTimeGoals() {
        return this.halfTimeGoals;
    }

    public void setHalfTimeGoals(GameResult _halfTimeGoals) {
        this.halfTimeGoals = _halfTimeGoals;
    }

    public void setHalfTimeGoals(int homeGoals, int guestGoals) {
        this.setHalfTimeGoals(new GameResult(homeGoals, guestGoals));
    }

    public GameResult getOverTimeGoals() {
        return this.overTimeGoals;
    }

    public void setOverTimeGoals(GameResult _overTimeGoals) {
        this.overTimeGoals = _overTimeGoals;
    }

    public void setOverTimeGoals(int homeGoals, int guestGoals) {
        this.setOverTimeGoals(new GameResult(homeGoals, guestGoals));
    }

    public GameResult getPenaltyGoals() {
        return this.penaltyGoals;
    }

    public void setPenaltyGoals(GameResult _penaltyGoals) {
        this.penaltyGoals = _penaltyGoals;
    }

    public void setPenaltyGoals(int homeGoals, int guestGoals) {
        this.setPenaltyGoals(new GameResult(homeGoals, guestGoals));
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location _location) {
        this.location = _location;
    }

    public boolean isPlayed() {
        return this.played;
    }

    public void setPlayed(boolean value) {
        this.played = value;
    }

    public GameList getGameList() {
        return this.gameList;
    }

    protected void setGameList(GameList value) {
        this.gameList = value;
    }

    public int getIndex() {
        return this.index;
    }

    protected void setIndex(int value) {
        this.index = value;
    }

    public List<Goal> getGoals() {
        return this.goals;
    }

    protected void setGoals(List<Goal> _goals) {
        this.goals = _goals;
    }

    public void addGoal(Goal goal) {
        this.goals.add(goal);
    }

    public Long getOpenligaid() {
        return this.openligaid;
    }

    public void setOpenligaid(Long value) {
        this.openligaid = value;
    }

    public boolean isKo() {
        return this.ko;
    }

    public void setKo(boolean value) {
        this.ko = value;
    }

    public int hashCode() {
        return 13;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Game other = (Game)obj;
        return this.id != null && this.id.equals(other.getId());
    }

    @Override
    public int compareTo(Game _game) {
        if (this.getIndex() < _game.getIndex()) {
            return -1;
        }
        if (this.getIndex() > _game.getIndex()) {
            return 1;
        }
        return 0;
    }

    public String debug() {
        StringBuilder buf = new StringBuilder();
        buf.append("ID=").append(this.getId()).append(", ");
        if (this.getDateTime() == null) {
            buf.append("Date: <null>");
        } else {
            buf.append("Date: ");
            buf.append(this.getDateTime());
        }
        buf.append(", ");
        if (this.getGroup() == null) {
            buf.append("Group: <null>");
        } else {
            buf.append(this.getGroup());
        }
        buf.append(", ");
        if (this.homeTeam == null) {
            buf.append("HTeam: <null>");
        } else {
            buf.append(this.homeTeam.getName());
        }
        buf.append(':');
        if (this.guestTeam == null) {
            buf.append("GTeam: <null>");
        } else {
            buf.append(this.guestTeam.getName());
        }
        buf.append(", Result=");
        buf.append(this.result);
        return buf.toString();
    }
}

