/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.storage.group.entity;

import de.betoffice.storage.AbstractStorageObject;
import de.betoffice.storage.group.GroupTypeEnum;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;

@Entity
@Table(name="bo_grouptype")
public class GroupType
extends AbstractStorageObject
implements Comparable<GroupType> {
    private static final long serialVersionUID = -8513852915020891940L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id", updatable=false, nullable=false)
    private Long id;
    @NotNull
    @Column(name="bo_name")
    private String name;
    @NotNull
    @Column(name="bo_type")
    @Enumerated
    private GroupTypeEnum type = GroupTypeEnum.LEAGUE;

    public static GroupType of(String groupTypeName) {
        GroupType groupType = new GroupType();
        groupType.setName(groupTypeName);
        return groupType;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    protected void setId(Long value) {
        this.id = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public GroupTypeEnum getType() {
        return this.type;
    }

    public void setType(GroupTypeEnum type) {
        this.type = type;
    }

    public boolean isValid() {
        return !StringUtils.isBlank((CharSequence)this.name);
    }

    @Override
    public int compareTo(GroupType o) {
        return this.getName().compareTo(o.getName());
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof GroupType)) {
            return false;
        }
        GroupType groupType = (GroupType)object;
        return groupType.getName().equals(this.getName());
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getName().hashCode();
        return result;
    }
}

