/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.service;

import de.betoffice.mail.NotificationType;
import de.betoffice.mail.SendUserProfileChangeMailNotification;
import de.betoffice.service.AbstractManagerService;
import de.betoffice.service.CommunityService;
import de.betoffice.storage.community.CommunityDao;
import de.betoffice.storage.community.CommunityFilter;
import de.betoffice.storage.community.entity.Community;
import de.betoffice.storage.community.entity.CommunityReference;
import de.betoffice.storage.season.SeasonDao;
import de.betoffice.storage.season.entity.Season;
import de.betoffice.storage.season.entity.SeasonReference;
import de.betoffice.storage.time.DateTimeProvider;
import de.betoffice.storage.user.UserDao;
import de.betoffice.storage.user.entity.Nickname;
import de.betoffice.storage.user.entity.User;
import de.betoffice.util.LoggerFactory;
import de.betoffice.validation.ServiceResult;
import de.betoffice.validation.ValidationException;
import de.betoffice.validation.ValidationMessage;
import jakarta.persistence.NoResultException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="communityService")
@Transactional(readOnly=true)
public class DefaultCommunityService
extends AbstractManagerService
implements CommunityService {
    private static final Logger LOG = LoggerFactory.make();
    private final CommunityDao communityDao;
    private final UserDao userDao;
    private final SeasonDao seasonDao;
    private final SendUserProfileChangeMailNotification sendUserProfileChangeMailNotification;
    private final DateTimeProvider dateTimeProvider;

    public DefaultCommunityService(CommunityDao communityDao, UserDao userDao, SeasonDao seasonDao, SendUserProfileChangeMailNotification sendUserProfileChangeMailNotification, DateTimeProvider dateTimeProvider) {
        this.communityDao = communityDao;
        this.userDao = userDao;
        this.seasonDao = seasonDao;
        this.sendUserProfileChangeMailNotification = sendUserProfileChangeMailNotification;
        this.dateTimeProvider = dateTimeProvider;
    }

    @Override
    public Optional<User> findUser(Nickname nickname) {
        return this.userDao.findByNickname(nickname);
    }

    @Override
    public List<User> findAllUsers() {
        return this.userDao.findAll();
    }

    @Override
    public User findUser(long userId) {
        return (User)this.userDao.findById(userId);
    }

    @Override
    public Optional<User> findUserByChangeToken(String changeToken) {
        return this.userDao.findByChangeToken(changeToken);
    }

    @Override
    public Community find(Long communityId) {
        return (Community)this.communityDao.findById(communityId);
    }

    @Override
    public Optional<Community> find(CommunityReference communityReference) {
        return this.communityDao.find(communityReference);
    }

    @Override
    public List<Community> find(String communityName) {
        return this.communityDao.find(communityName);
    }

    @Override
    public Page<Community> findCommunities(CommunityFilter communityFilter, Pageable pageable) {
        return this.communityDao.findAll(communityFilter, pageable);
    }

    @Override
    public Page<User> findUsers(String nicknameFilter, Pageable pageable) {
        return this.userDao.findAll(nicknameFilter, pageable);
    }

    @Override
    public Set<User> findMembers(CommunityReference communityReference) {
        try {
            Community community = this.communityDao.findMembers(communityReference);
            return community.getUsers();
        }
        catch (NoResultException ex) {
            return Set.of();
        }
    }

    @Override
    @Transactional
    public ServiceResult<Community> create(CommunityReference communityRef, SeasonReference seasonRef, String communityName, String communityYear, Nickname managerNickname) {
        Optional<Community> definedCommunity = this.communityDao.find(communityRef);
        if (definedCommunity.isPresent()) {
            return ServiceResult.failure(ValidationMessage.MessageType.COMMUNITY_EXISTS);
        }
        Season persistedSeason = this.seasonDao.find(seasonRef).orElseThrow(() -> new IllegalArgumentException(String.format("%s does not exist.", seasonRef)));
        User communityManager = this.userDao.findByNickname(managerNickname).orElseThrow(() -> new IllegalArgumentException(String.format("%s does not exist.", managerNickname)));
        Community community = new Community();
        community.setYear(communityYear);
        community.setName(communityName);
        community.setReference(communityRef);
        community.setCommunityManager(communityManager);
        community.setSeason(persistedSeason);
        this.communityDao.persist(community);
        return ServiceResult.sucess(community);
    }

    @Override
    @Transactional
    public void delete(CommunityReference reference) {
        Community community = this.communityDao.find(reference).orElseThrow();
        if (this.communityDao.hasMembers(reference)) {
            LOG.warn("Unable to delete community '{}'. The Community has members.", (Object)community);
            throw new IllegalArgumentException("Unable to delete community. The Community has members.");
        }
        this.communityDao.delete(community);
    }

    @Override
    @Transactional
    public Community addMember(CommunityReference communityReference, Nickname nickname) {
        Community community = this.communityDao.find(communityReference).orElseThrow();
        User user = this.userDao.findByNickname(nickname).orElseThrow();
        community.addMember(user);
        this.communityDao.update(community);
        return community;
    }

    @Override
    @Transactional
    public Community addMembers(CommunityReference communityReference, Set<Nickname> nicknames) {
        Community community = this.communityDao.find(communityReference).orElseThrow();
        nicknames.stream().map(n -> this.userDao.findByNickname((Nickname)n)).forEach(u -> u.ifPresent(us -> community.addMember((User)us)));
        this.communityDao.update(community);
        return community;
    }

    @Override
    @Transactional
    public Community removeMember(CommunityReference reference, Nickname nickname) {
        User user = this.userDao.findByNickname(nickname).orElseThrow();
        Community community = this.communityDao.find(reference).orElseThrow();
        community.removeMember(user);
        this.communityDao.update(community);
        return community;
    }

    @Override
    @Transactional
    public Community removeMembers(CommunityReference reference, Set<Nickname> nicknames) {
        nicknames.stream().forEach(nickname -> this.removeMember(reference, (Nickname)nickname));
        return this.communityDao.find(reference).orElseThrow();
    }

    @Override
    @Transactional
    public User createUser(User user) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        if (user.getNickname() == null || StringUtils.isBlank((CharSequence)user.getNickname().value())) {
            messages.add(ValidationMessage.error(ValidationMessage.MessageType.NICKNAME_IS_NOT_SET));
        }
        if (!messages.isEmpty()) {
            throw new ValidationException(messages);
        }
        this.userDao.persist(user);
        return user;
    }

    @Override
    @Transactional
    public void deleteUser(Nickname nickname) {
        this.userDao.findByNickname(nickname).ifPresent(u -> this.userDao.delete(u));
    }

    @Override
    @Transactional
    public Optional<User> updateUser(boolean adminOperation, Nickname nickname, String name, String surname, String mail, boolean emailNotification, String phone) {
        return this.userDao.findByNickname(nickname).map(u -> {
            u.setName(name);
            u.setSurname(surname);
            u.setPhone(phone);
            u.setNotification(emailNotification ? NotificationType.TIPP : NotificationType.NONE);
            if (!adminOperation && this.hasUserChangedHisMailAddress((User)u, mail) && u.getChangeSend() < 5) {
                u.setChangeEmail(mail);
                u.setChangeToken(UUID.randomUUID().toString());
                u.setChangeDateTime(this.dateTimeProvider.currentDateTime());
                u.setChangeDateTime(this.dateTimeProvider.currentDateTime());
                this.sendUserProfileChangeMailNotification.send((User)u);
                u.incrementChangeSend();
            } else {
                u.setEmail(mail);
                u.abortEmailChange();
            }
            return u;
        });
    }

    private boolean hasUserChangedHisMailAddress(User user, String newMailAddress) {
        return !StringUtils.equals((CharSequence)user.getEmail(), (CharSequence)newMailAddress);
    }

    @Override
    @Transactional
    public ServiceResult<User> confirmMailAddressChange(Nickname nickname, String changeToken) {
        Optional<User> optionalUser = this.userDao.findByNickname(nickname);
        if (optionalUser.isEmpty()) {
            return ServiceResult.failureWithFormattedError(ValidationMessage.MessageType.USER_NOT_FOUND, nickname.toString());
        }
        User user = optionalUser.get();
        if (StringUtils.equals((CharSequence)changeToken, (CharSequence)user.getChangeToken())) {
            ZonedDateTime changeDateTime = user.getChangeDateTime();
            ZonedDateTime changeDateTimePlusTenMinutes = changeDateTime.plusMinutes(10L);
            ZonedDateTime now = this.dateTimeProvider.currentDateTime();
            if (changeDateTime.isAfter(now)) {
                return ServiceResult.failure(ValidationMessage.MessageType.EMAIL_CHANGE_DATETIME_IS_IN_THE_FUTURE);
            }
            if (now.isBefore(changeDateTimePlusTenMinutes)) {
                user.acceptEmailChange();
                return ServiceResult.sucess(user);
            }
            return ServiceResult.failure(ValidationMessage.MessageType.EMAIL_CHANGE_DATETIME_EXPIRED);
        }
        LOG.warn("Unable to confirm email change. ChangeTokens are different. {} vs {}", (Object)changeToken, (Object)user.getChangeToken());
        throw new IllegalArgumentException("Unable to confirm email change. ChangeTokens are different.");
    }

    @Override
    @Transactional
    public Optional<User> abortMailAddressChange(Nickname nickname) {
        return this.userDao.findByNickname(nickname).map(u -> u.abortEmailChange());
    }

    @Override
    @Transactional
    public Optional<User> resubmitConfirmationMail(Nickname nickname) {
        return this.userDao.findByNickname(nickname).filter(u -> u.getChangeSend() < 5).map(u -> this.sendUserProfileChangeMailNotification.send((User)u));
    }
}

