/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.web.boot;

import jakarta.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.env.Environment;

@SpringBootApplication
@EnableAutoConfiguration(exclude={DataSourceAutoConfiguration.class})
@ComponentScan(basePackages={"de.betoffice", "de.winkler.betoffice"})
public class BetofficeBootApplication {
    @Autowired
    private Environment env;

    public static void main(String[] args) {
        SpringApplication.run(BetofficeBootApplication.class, (String[])args);
    }

    @PostConstruct
    public void onStartup() {
        String[] profiles = this.env.getActiveProfiles();
        System.out.println(String.format("Activated spring profile: %s", this.profilesToString(profiles)));
    }

    private String profilesToString(String[] profiles) {
        return String.join((CharSequence)",", profiles);
    }
}

