/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.web.tipp;

import de.betoffice.service.AuthService;
import de.betoffice.service.CommunityService;
import de.betoffice.service.SeasonManagerService;
import de.betoffice.service.TippService;
import de.betoffice.storage.season.entity.GameList;
import de.betoffice.storage.session.entity.Session;
import de.betoffice.storage.time.DateTimeProvider;
import de.betoffice.storage.tip.TippDto;
import de.betoffice.storage.user.entity.Nickname;
import de.betoffice.storage.user.entity.User;
import de.betoffice.web.AccessDeniedException;
import de.betoffice.web.json.GameJson;
import de.betoffice.web.json.IGameJson;
import de.betoffice.web.json.JsonAssembler;
import de.betoffice.web.json.JsonBuilder;
import de.betoffice.web.json.RoundJson;
import de.betoffice.web.tipp.OfficeTippService;
import de.betoffice.web.tipp.SubmitTippGameJson;
import de.betoffice.web.tipp.SubmitTippRoundJson;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class DefaultOfficeTippService
implements OfficeTippService {
    @Autowired
    private DateTimeProvider dateTimeProvider;
    @Autowired
    private SeasonManagerService seasonManagerService;
    @Autowired
    private CommunityService communityService;
    @Autowired
    private TippService tippService;
    @Autowired
    private AuthService authService;

    @Override
    @Transactional
    public RoundJson submitTipp(String token, SubmitTippRoundJson tippRoundJson) throws AccessDeniedException {
        Session session = (Session)this.authService.validateSession(token).orElseThrow(() -> new AccessDeniedException());
        if (!StringUtils.equals((CharSequence)session.getUser().getNickname().value(), (CharSequence)tippRoundJson.getNickname())) {
            throw new AccessDeniedException();
        }
        TippDto tippDto = new TippDto();
        tippDto.setNickname(tippRoundJson.getNickname());
        tippDto.setRoundId(tippRoundJson.getRoundId());
        tippDto.setToken(token);
        tippDto.setSubmitTime(this.dateTimeProvider.currentDateTime());
        for (SubmitTippGameJson submitTippJson : tippRoundJson.getSubmitTippGames()) {
            TippDto.GameTippDto gameTippDto = new TippDto.GameTippDto();
            gameTippDto.setGameId(submitTippJson.getGameId());
            gameTippDto.setHomeGoals(submitTippJson.getTippResult().getHomeGoals());
            gameTippDto.setGuestGoals(submitTippJson.getTippResult().getGuestGoals());
            tippDto.addGameTipp(gameTippDto);
        }
        List tipps = this.tippService.validateKickOffTimeAndAddTipp(tippDto);
        return this.findTipp(tippRoundJson.getRoundId(), tippRoundJson.getNickname());
    }

    @Override
    public RoundJson findTipp(Long roundId, String nickName) {
        Optional user = this.communityService.findUser(Nickname.of((String)nickName));
        if (!user.isPresent()) {
            return null;
        }
        RoundJson roundJson = null;
        Optional round = this.seasonManagerService.findRoundGames(roundId.longValue());
        if (round.isPresent()) {
            List roundTipps = this.tippService.findTipps((GameList)round.get(), (User)user.get());
            Optional nextNextRound = this.seasonManagerService.findNextRound(roundId.longValue());
            JsonAssembler jsonAssembler = new JsonAssembler();
            roundJson = roundTipps.isEmpty() ? jsonAssembler.build((GameList)round.get()).lastRound(!nextNextRound.isPresent()).games().emptyTipp().assemble() : jsonAssembler.build((GameList)round.get()).lastRound(!nextNextRound.isPresent()).games().tipps(roundTipps).assemble();
        }
        return roundJson;
    }

    @Override
    public Optional<RoundJson> findCurrentTipp(Long seasonId, String nickName) {
        ZonedDateTime currentDateTime = this.dateTimeProvider.currentDateTime();
        return this.tippService.findNextTippRound(seasonId.longValue(), currentDateTime).map(i -> this.findTipp(i.getId(), nickName));
    }

    @Override
    public Optional<RoundJson> findNextTipp(Long roundId, String nickName) {
        return this.seasonManagerService.findNextRound(roundId.longValue()).map(i -> this.findTipp(i.getId(), nickName));
    }

    @Override
    public Optional<RoundJson> findPrevTipp(Long roundId, String nickName) {
        return this.seasonManagerService.findPrevRound(roundId.longValue()).map(i -> this.findTipp(i.getId(), nickName));
    }

    @Override
    public Optional<RoundJson> findTippRound(Long seasonId) {
        return this.tippService.findNextTippRound(seasonId.longValue(), this.dateTimeProvider.currentDateTime()).map(gameList -> {
            RoundJson roundJson = JsonBuilder.toJson(gameList);
            List<GameJson> gameJson = JsonBuilder.toJsonWithGames(gameList.unmodifiableList());
            roundJson.getGames().addAll(gameJson);
            roundJson.setTippable(this.isFinished(roundJson));
            return roundJson;
        });
    }

    private boolean isFinished(RoundJson round) {
        boolean finished = false;
        for (IGameJson iGameJson : round.getGames()) {
            if (iGameJson.isFinished()) continue;
            finished = true;
        }
        return finished;
    }
}

