/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.web.security;

import de.betoffice.storage.user.RoleType;
import de.betoffice.storage.user.entity.User;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

class BetofficeUserDetails
implements UserDetails {
    private static final long serialVersionUID = 1L;
    private final User user;
    private final List<SimpleGrantedAuthority> authorities;

    BetofficeUserDetails(User user, List<RoleType> roleTypes) {
        this.user = user;
        this.authorities = roleTypes.stream().map(Enum::name).map(SimpleGrantedAuthority::new).collect(Collectors.toList());
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public String getPassword() {
        return this.user.getPassword();
    }

    public String getUsername() {
        return this.user.getNickname().value();
    }

    public boolean isAccountNonExpired() {
        return this.user.isExcluded();
    }

    public boolean isAccountNonLocked() {
        return false;
    }

    public boolean isCredentialsNonExpired() {
        return false;
    }

    public boolean isEnabled() {
        return !this.user.isExcluded();
    }
}

