/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.web.season;

import de.betoffice.service.CommunityCalculatorService;
import de.betoffice.service.CommunityService;
import de.betoffice.service.MasterDataManagerService;
import de.betoffice.service.SeasonManagerService;
import de.betoffice.service.TippService;
import de.betoffice.storage.group.entity.GroupType;
import de.betoffice.storage.season.SeasonRange;
import de.betoffice.storage.season.entity.Game;
import de.betoffice.storage.season.entity.GameList;
import de.betoffice.storage.season.entity.Group;
import de.betoffice.storage.season.entity.Season;
import de.betoffice.storage.season.entity.SeasonReference;
import de.betoffice.storage.team.TeamResult;
import de.betoffice.storage.team.TeamType;
import de.betoffice.storage.time.DateTimeProvider;
import de.betoffice.storage.tip.GameTipp;
import de.betoffice.storage.user.UserResult;
import de.betoffice.web.json.GameJson;
import de.betoffice.web.json.GameWithGoalsJson;
import de.betoffice.web.json.GroupTeamTableJson;
import de.betoffice.web.json.GroupTypeJson;
import de.betoffice.web.json.IGameJson;
import de.betoffice.web.json.JsonAssembler;
import de.betoffice.web.json.JsonBuilder;
import de.betoffice.web.json.PingJson;
import de.betoffice.web.json.RoundAndTableJson;
import de.betoffice.web.json.RoundJson;
import de.betoffice.web.json.SeasonJson;
import de.betoffice.web.json.TeamJson;
import de.betoffice.web.json.TeamResultJson;
import de.betoffice.web.json.UserJson;
import de.betoffice.web.json.UserTableJson;
import de.betoffice.web.json.builder.GoalJsonMapper;
import de.betoffice.web.json.builder.TeamJsonMapper;
import de.betoffice.web.season.BetofficeService;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="betofficeBasicService")
@Transactional(readOnly=true)
public class DefaultBetofficeService
implements BetofficeService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultBetofficeService.class);
    @Autowired
    private DateTimeProvider dateTimeProvider;
    @Autowired
    private SeasonManagerService seasonManagerService;
    @Autowired
    private MasterDataManagerService masterDataManagerService;
    @Autowired
    private TippService tippService;
    @Autowired
    private CommunityCalculatorService communityCalculatorService;

    @Override
    public SeasonJson findSeasonById(Long seasonId) {
        Season season = this.seasonManagerService.findSeasonById(seasonId.longValue());
        List rounds = this.seasonManagerService.findRounds(season);
        Optional nextTippRound = this.tippService.findNextTippRound(seasonId.longValue(), this.dateTimeProvider.currentDateTime());
        JsonAssembler jsonAssembler = new JsonAssembler();
        SeasonJson seasonJson = jsonAssembler.build(season).rounds(rounds).currentRound(nextTippRound).assemble();
        return seasonJson;
    }

    @Override
    public List<GroupTypeJson> findAllGroups(Long seasonId) {
        Season season = this.seasonManagerService.findSeasonById(seasonId.longValue());
        List groupTypes = this.seasonManagerService.findGroupTypesBySeason(season);
        return JsonBuilder.toJsonWithGroupTypes(groupTypes);
    }

    @Override
    public List<RoundJson> findAllRounds(Long seasonId) {
        Season season = this.seasonManagerService.findSeasonById(seasonId.longValue());
        List rounds = this.seasonManagerService.findRounds(season);
        return JsonBuilder.toJsonWithGameList(rounds);
    }

    @Override
    public SeasonJson findAllRounds(Long seasonId, Long groupTypeId) {
        Season season = this.seasonManagerService.findSeasonById(seasonId.longValue());
        GroupType groupType = this.masterDataManagerService.findGroupType(groupTypeId.longValue());
        Group group = this.seasonManagerService.findGroup(season, groupType);
        List rounds = this.seasonManagerService.findRounds(group);
        Optional nextTippRound = this.tippService.findNextTippRound(seasonId.longValue(), this.dateTimeProvider.currentDateTime());
        JsonAssembler jsonAssembler = new JsonAssembler();
        SeasonJson seasonJson = jsonAssembler.build(season).rounds(rounds).currentRound(nextTippRound).assemble();
        return seasonJson;
    }

    @Override
    public RoundJson findRound(Long seasonId, Long roundId) {
        Season season = this.seasonManagerService.findSeasonById(seasonId.longValue());
        GameList gameList = this.seasonManagerService.findRound(roundId.longValue());
        RoundJson roundJson = null;
        if (gameList == null) {
            Optional firstRound = this.seasonManagerService.findFirstRound(season);
            JsonAssembler jsonAssembler = new JsonAssembler();
            roundJson = jsonAssembler.build((GameList)firstRound.get()).games().lastRound(true).assemble();
        } else {
            Optional nextRound = this.seasonManagerService.findNextRound(roundId.longValue());
            JsonAssembler jsonAssembler = new JsonAssembler();
            roundJson = jsonAssembler.build(gameList).games().lastRound(!nextRound.isPresent()).assemble();
        }
        return roundJson;
    }

    @Override
    public RoundJson findRoundByGroup(Long seasonId, Long roundId, Long groupTypeId) {
        Season season = this.seasonManagerService.findSeasonById(seasonId.longValue());
        GameList gameList = this.seasonManagerService.findRoundGames(roundId.longValue()).orElseGet(() -> (GameList)this.seasonManagerService.findFirstRound(season).orElseThrow());
        GroupType groupType = this.masterDataManagerService.findGroupType(groupTypeId.longValue());
        Group group = this.seasonManagerService.findGroup(season, groupType);
        RoundJson roundJson = null;
        if (gameList != null) {
            Optional nextRound = this.seasonManagerService.findNextRound(roundId.longValue());
            JsonAssembler jsonAssembler = new JsonAssembler();
            roundJson = jsonAssembler.build(gameList).games(gameList.toList(group)).lastRound(!nextRound.isPresent()).assemble();
        }
        return roundJson;
    }

    @Override
    public RoundJson findNextRound(Long seasonId, Long roundId) {
        Optional nextRound = this.seasonManagerService.findNextRound(roundId.longValue());
        RoundJson roundJson = null;
        if (nextRound.isPresent()) {
            Optional nextNextRound = this.seasonManagerService.findNextRound(((GameList)nextRound.get()).getId().longValue());
            JsonAssembler jsonAssembler = new JsonAssembler();
            roundJson = jsonAssembler.build((GameList)nextRound.get()).lastRound(!nextNextRound.isPresent()).games().assemble();
        }
        return roundJson;
    }

    @Override
    public RoundJson findPrevRound(Long seasonId, Long roundId) {
        Optional prevRound = this.seasonManagerService.findPrevRound(roundId.longValue());
        RoundJson roundJson = null;
        if (prevRound.isPresent()) {
            JsonAssembler jsonAssembler = new JsonAssembler();
            roundJson = jsonAssembler.build((GameList)prevRound.get()).lastRound(false).games().assemble();
        }
        return roundJson;
    }

    @Override
    public RoundAndTableJson findRoundTable(Long seasonId, Long roundId, Long groupTypeId) {
        RoundJson roundJson = this.findRoundByGroup(seasonId, roundId, groupTypeId);
        Season season = this.seasonManagerService.findSeasonById(seasonId.longValue());
        GroupType groupType = this.masterDataManagerService.findGroupType(groupTypeId.longValue());
        RoundAndTableJson roundAndTableJson = new RoundAndTableJson();
        roundAndTableJson.setRoundJson(roundJson);
        List teamRanking = this.seasonManagerService.calculateTeamRanking(season, groupType, 0, roundJson.getIndex() - 1);
        GroupTeamTableJson groupTeamTableJson = new GroupTeamTableJson();
        groupTeamTableJson.setGroupTypeJson(JsonBuilder.toJson(groupType));
        for (TeamResult teamResult : teamRanking) {
            TeamResultJson teamResultJson = JsonBuilder.toJson(teamResult);
            groupTeamTableJson.add(teamResultJson);
        }
        roundAndTableJson.setGroupTeamTableJson(groupTeamTableJson);
        return roundAndTableJson;
    }

    @Override
    public RoundAndTableJson findNextRoundTable(Long seasonId, Long roundId) {
        return this.findRoundTable(seasonId, roundId, null);
    }

    @Override
    public RoundAndTableJson findPrevRoundTable(Long seasonId, Long roundId) {
        return this.findRoundTable(seasonId, roundId, null);
    }

    @Override
    public GameJson findGame(Long gameId) {
        Game game = this.seasonManagerService.findMatch(gameId);
        return JsonBuilder.toJson(game);
    }

    @Override
    public GameWithGoalsJson findDetailGame(Long gameId) {
        Game game = this.seasonManagerService.findMatch(gameId);
        List goals = this.seasonManagerService.findGoalsOfMatch(game);
        GameWithGoalsJson json = JsonBuilder.toGameWithGoalsJson(game);
        json.setGoals(GoalJsonMapper.map(goals));
        return json;
    }

    @Override
    public Optional<RoundJson> findCurrent(Long seasonId) {
        return this.tippService.findNextTippRound(seasonId.longValue(), this.dateTimeProvider.currentDateTime()).map(i -> JsonBuilder.toJson(i));
    }

    @Override
    public UserTableJson calcUserRanking(Long seasonId) {
        Season season = this.seasonManagerService.findSeasonById(seasonId.longValue());
        Optional round = this.tippService.findPreviousTippRound(seasonId.longValue(), this.dateTimeProvider.currentDateTime());
        UserTableJson userTableJson = new UserTableJson();
        if (round.isEmpty()) {
            Optional lastRound;
            round = lastRound = this.seasonManagerService.findFirstRound(season);
        }
        userTableJson.setRound(JsonBuilder.toJson((GameList)round.get()));
        return this.calcUserRanking(userTableJson, (GameList)round.get(), 0);
    }

    @Override
    public UserTableJson calcUserRankingByRoundOnly(Long roundId) {
        Optional round = this.seasonManagerService.findRoundGames(roundId.longValue());
        if (round.isPresent()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Calculate user ranking for a single round: {}", (Object)((GameList)round.get()).getDateTime());
                for (Game game : ((GameList)round.get()).unmodifiableList()) {
                    LOG.debug("Game: {}", (Object)game.debug());
                }
            }
            List tipps = this.tippService.findTipps(roundId.longValue());
            if (LOG.isDebugEnabled()) {
                for (GameTipp tipp : tipps) {
                    LOG.debug("GameTipp: {}", (Object)tipp.debug());
                }
            }
            UserTableJson userTableJson = new UserTableJson();
            userTableJson.setRound(JsonBuilder.toJson((GameList)round.get()));
            List<GameJson> jsonWithGamesAndTipps = JsonBuilder.toJsonWithGamesAndTipps((List<Game>)((GameList)round.get()).unmodifiableList(), tipps);
            userTableJson.getRound().setGames(jsonWithGamesAndTipps);
            return this.calcUserRanking(userTableJson, (GameList)round.get(), ((GameList)round.get()).getIndex());
        }
        return null;
    }

    @Override
    public UserTableJson calcUserRankingByRound(Long roundId) {
        Optional round = this.seasonManagerService.findRoundGames(roundId.longValue());
        UserTableJson userTableJson = new UserTableJson();
        userTableJson.setRound(JsonBuilder.toJson((GameList)round.get()));
        List tipps = this.tippService.findTipps(roundId.longValue());
        List<GameJson> jsonWithGamesAndTipps = JsonBuilder.toJsonWithGamesAndTipps((List<Game>)((GameList)round.get()).unmodifiableList(), tipps);
        userTableJson.getRound().setGames(jsonWithGamesAndTipps);
        return this.calcUserRanking(userTableJson, (GameList)round.get(), 0);
    }

    private UserTableJson calcUserRanking(UserTableJson userTableJson, GameList round, int startIndex) {
        Season season = this.seasonManagerService.findSeasonById(round.getSeason().getId().longValue());
        List calculatedRanking = this.communityCalculatorService.calculateRanking(CommunityService.defaultPlayerGroup((SeasonReference)season.getReference()), SeasonRange.of((int)startIndex, (int)round.getIndex()));
        for (UserResult ur : calculatedRanking) {
            UserJson userJson = JsonBuilder.toJson(ur);
            userTableJson.addUser(userJson);
        }
        SeasonJson seasonJson = JsonBuilder.toJson(round.getSeason());
        userTableJson.setSeason(seasonJson);
        this.findNextAndPrevRound(round, userTableJson);
        return userTableJson;
    }

    private void findNextAndPrevRound(GameList round, UserTableJson userTableJson) {
        Optional nextNextRound = this.seasonManagerService.findNextRound(round.getId().longValue());
        userTableJson.getRound().setLastRound(!nextNextRound.isPresent());
        userTableJson.getRound().setTippable(this.isFinished(userTableJson.getRound()));
    }

    @Override
    public UserTableJson calcUserRankingByNextRound(Long roundId) {
        Optional nextRound = this.seasonManagerService.findNextRound(roundId.longValue());
        if (nextRound.isPresent()) {
            return this.calcUserRankingByRound(((GameList)nextRound.get()).getId());
        }
        return null;
    }

    @Override
    public UserTableJson calcUserRankingByPrevRound(Long roundId) {
        Optional prevRound = this.seasonManagerService.findPrevRound(roundId.longValue());
        if (prevRound.isPresent()) {
            return this.calcUserRankingByRound(((GameList)prevRound.get()).getId());
        }
        return null;
    }

    @Override
    public List<TeamJson> findAllTeams() {
        List teams = this.masterDataManagerService.findAllTeams();
        return JsonBuilder.toJsonWithTeams(teams);
    }

    @Override
    public List<TeamJson> findTeams(Optional<TeamType> teamType, String filter) {
        return TeamJsonMapper.map(this.masterDataManagerService.findTeams(teamType, filter));
    }

    @Override
    public List<SeasonJson> findAllSeason() {
        List seasons = this.seasonManagerService.findAllSeasons();
        return JsonBuilder.toJsonWithSeasons(seasons);
    }

    private boolean isFinished(RoundJson round) {
        boolean finished = false;
        for (IGameJson iGameJson : round.getGames()) {
            if (iGameJson.isFinished()) continue;
            finished = true;
        }
        return finished;
    }

    @Override
    public PingJson ping() {
        PingJson pingJson = new PingJson();
        pingJson.setDateTime(this.dateTimeProvider.currentDateTime());
        return pingJson;
    }
}

