/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.web.json.builder;

import de.betoffice.mail.NotificationType;
import de.betoffice.storage.user.entity.Nickname;
import de.betoffice.storage.user.entity.User;
import de.betoffice.web.json.UserProfileJson;
import java.util.List;
import java.util.Optional;

public class UserProfileJsonMapper {
    public static Optional<UserProfileJson> map(Optional<User> user) {
        return user.map(UserProfileJsonMapper::map);
    }

    public static UserProfileJson map(User user) {
        return UserProfileJsonMapper.map(user, new UserProfileJson());
    }

    public static UserProfileJson map(User user, UserProfileJson partyJson) {
        partyJson.setName(user.getName());
        partyJson.setSurname(user.getSurname());
        partyJson.setMail(user.getEmail());
        partyJson.setEmailNotificationEnabled(NotificationType.TIPP.equals((Object)user.getNotification()));
        partyJson.setAlternativeMail(user.getChangeEmail());
        partyJson.setNickname(user.getNickname().value());
        partyJson.setPhone(user.getPhone());
        return partyJson;
    }

    public static List<UserProfileJson> map(List<User> users) {
        return users.stream().map(UserProfileJsonMapper::map).toList();
    }

    public static User reverse(UserProfileJson partyJson, User user) {
        user.setName(partyJson.getName());
        user.setSurname(partyJson.getSurname());
        user.setEmail(partyJson.getMail());
        user.setNotification(partyJson.isEmailNotificationEnabled() ? NotificationType.TIPP : NotificationType.NONE);
        user.setNickname(Nickname.of((String)partyJson.getNickname()));
        user.setPhone(partyJson.getPhone());
        return user;
    }
}

