/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.web.json.builder;

import de.betoffice.storage.team.TeamType;
import de.betoffice.storage.team.entity.Team;
import de.betoffice.web.json.TeamJson;
import java.util.List;

public class TeamJsonMapper {
    public static TeamJson map(Team team, TeamJson teamJson) {
        teamJson.setId(team.getId());
        teamJson.setOpenligaid(team.getOpenligaid());
        teamJson.setLogo(team.getLogo());
        teamJson.setLongName(team.getLongName());
        teamJson.setName(team.getName());
        teamJson.setShortName(team.getShortName());
        teamJson.setXshortName(team.getXshortName());
        teamJson.setType(team.getTeamType().name());
        return teamJson;
    }

    public static List<TeamJson> map(List<Team> teams) {
        return teams.stream().map(TeamJsonMapper::map).toList();
    }

    private static TeamJson map(Team team) {
        return TeamJsonMapper.map(team, new TeamJson());
    }

    public static Team reverse(TeamJson teamJson, Team team) {
        team.setOpenligaid(teamJson.getOpenligaid());
        team.setLogo(teamJson.getLogo());
        team.setLongName(teamJson.getLongName());
        team.setName(teamJson.getName());
        team.setShortName(teamJson.getShortName());
        team.setXshortName(teamJson.getXshortName());
        team.setTeamType(TeamType.valueOf((String)teamJson.getType()));
        return team;
    }
}

