/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.web.json.builder;

import de.betoffice.storage.season.entity.Game;
import de.betoffice.web.json.GameResultJson;
import de.betoffice.web.json.IGameJson;
import de.betoffice.web.json.JsonBuilder;
import java.util.List;
import java.util.function.Supplier;

public class GameJsonMapper {
    public static <T extends IGameJson> T map(Game game, T gameJson) {
        gameJson.setId(game.getId());
        gameJson.setRoundId(game.getGameList().getId());
        gameJson.setOpenligaid(game.getOpenligaid());
        gameJson.setIndex(game.getIndex());
        gameJson.setFinished(game.isPlayed());
        gameJson.setKo(game.isKo());
        gameJson.setDateTime(game.getDateTime());
        GameResultJson halfTimeGoals = JsonBuilder.toJson(game.getHalfTimeGoals());
        gameJson.setHalfTimeResult(halfTimeGoals);
        GameResultJson gameResult = JsonBuilder.toJson(game.getResult());
        gameJson.setResult(gameResult);
        GameResultJson penaltyGoals = JsonBuilder.toJson(game.getPenaltyGoals());
        gameJson.setPenaltyResult(penaltyGoals);
        GameResultJson overtimeGoals = JsonBuilder.toJson(game.getOverTimeGoals());
        gameJson.setOvertimeResult(overtimeGoals);
        gameJson.setHomeTeam(JsonBuilder.toJson(game.getHomeTeam()));
        gameJson.setGuestTeam(JsonBuilder.toJson(game.getGuestTeam()));
        gameJson.setGroupType(JsonBuilder.toJson(game.getGroup().getGroupType()));
        return gameJson;
    }

    public static <T extends IGameJson> List<T> map(List<Game> games, Supplier<T> supplier) {
        return games.stream().map(game -> {
            IGameJson json = (IGameJson)supplier.get();
            json = GameJsonMapper.map(game, json);
            return json;
        }).toList();
    }
}

