/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.web.json;

import de.betoffice.storage.season.entity.Game;
import de.betoffice.storage.season.entity.GameList;
import de.betoffice.storage.season.entity.Season;
import de.betoffice.storage.tip.GameTipp;
import de.betoffice.web.json.GameJson;
import de.betoffice.web.json.GameResultJson;
import de.betoffice.web.json.GameTippJson;
import de.betoffice.web.json.IGameJson;
import de.betoffice.web.json.JsonBuilder;
import de.betoffice.web.json.RoundJson;
import de.betoffice.web.json.SeasonJson;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

public class JsonAssembler {
    public SeasonAssembler build(Season season) {
        return new SeasonAssembler(season);
    }

    public RoundAssembler build(GameList round) {
        return new RoundAssembler(round);
    }

    public static class SeasonAssembler {
        private Season season;
        private List<GameList> rounds;
        private GameList currentRound;

        private SeasonAssembler(Season _season) {
            this.season = _season;
        }

        public SeasonAssembler rounds() {
            this.rounds = this.season.toGameList();
            return this;
        }

        public SeasonAssembler rounds(List<GameList> _rounds) {
            this.rounds = _rounds;
            return this;
        }

        public SeasonAssembler rounds(Predicate<GameList> filter) {
            this.rounds = this.season.toGameList(filter);
            return this;
        }

        public SeasonAssembler currentRound(GameList _currentRound) {
            this.currentRound = _currentRound;
            return this;
        }

        public SeasonAssembler currentRound(Optional<GameList> _currentRound) {
            return this.currentRound((GameList)_currentRound.orElse(null));
        }

        public SeasonJson assemble() {
            SeasonJson seasonJson = JsonBuilder.toJson(this.season);
            if (this.rounds == null || this.rounds.isEmpty()) {
                seasonJson.getRounds().clear();
            } else {
                List<RoundJson> gameListJson = JsonBuilder.toJsonWithGameList(this.rounds);
                seasonJson.getRounds().clear();
                seasonJson.getRounds().addAll(gameListJson);
            }
            if (this.currentRound != null) {
                seasonJson.setCurrentRoundId(this.currentRound.getId());
            }
            return seasonJson;
        }
    }

    public static class RoundAssembler {
        private GameList round;
        private List<Game> games;
        private List<GameTipp> tipps;
        private boolean lastRound = false;
        private boolean hasToAddTipp = false;
        private boolean hasToAddEmptyTipp = false;

        private RoundAssembler(GameList _round) {
            this.round = _round;
        }

        public RoundAssembler games(Predicate<Game> filter) {
            this.games = this.round.toList(filter);
            return this;
        }

        public RoundAssembler games(List<Game> _games) {
            this.games = _games;
            return this;
        }

        public RoundAssembler games() {
            this.games = this.round.unmodifiableList();
            return this;
        }

        public RoundAssembler tipps() {
            this.hasToAddTipp = true;
            return this;
        }

        public RoundAssembler tipps(List<GameTipp> _tipps) {
            this.tipps = _tipps;
            return this;
        }

        public RoundAssembler emptyTipp() {
            this.hasToAddEmptyTipp = true;
            return this;
        }

        public RoundAssembler lastRound(boolean _lastRound) {
            this.lastRound = _lastRound;
            return this;
        }

        public RoundJson assemble() {
            RoundJson roundJson = JsonBuilder.toJson(this.round);
            if (this.games == null || this.games.isEmpty()) {
                roundJson.getGames().clear();
            } else {
                List<GameJson> gameJsons = null;
                if (this.hasToAddEmptyTipp) {
                    gameJsons = JsonBuilder.toJsonWithGames(this.games);
                    for (GameJson gj : gameJsons) {
                        GameTippJson gameTippJson = new GameTippJson();
                        gameTippJson.setTipp(new GameResultJson());
                        gj.addTipp(gameTippJson);
                    }
                } else {
                    gameJsons = this.tipps != null && !this.tipps.isEmpty() ? JsonBuilder.toJsonWithGamesAndTipps(this.games, this.tipps) : (this.hasToAddTipp ? JsonBuilder.toJsonWithGamesAndTipps(this.games, this.tipps) : JsonBuilder.toJsonWithGames(this.games));
                }
                roundJson.getGames().clear();
                roundJson.getGames().addAll(gameJsons);
            }
            roundJson.setLastRound(this.lastRound);
            roundJson.setTippable(!this.isFinished(roundJson));
            return roundJson;
        }

        private boolean isFinished(RoundJson round) {
            boolean finished = true;
            if (this.games == null || this.games.isEmpty()) {
                finished = false;
            } else {
                for (IGameJson iGameJson : round.getGames()) {
                    finished = finished && iGameJson.isFinished();
                }
            }
            return finished;
        }
    }
}

