/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.web.community;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.betoffice.service.CommunityService;
import de.betoffice.storage.community.CommunityFilter;
import de.betoffice.storage.community.entity.CommunityReference;
import de.betoffice.storage.season.entity.SeasonReference;
import de.betoffice.storage.user.entity.Nickname;
import de.betoffice.validation.ServiceResult;
import de.betoffice.web.PageParam;
import de.betoffice.web.PageParamObjectMapper;
import de.betoffice.web.SortParam;
import de.betoffice.web.json.CommunityJson;
import de.betoffice.web.json.PartyJson;
import de.betoffice.web.json.SeasonJson;
import de.betoffice.web.json.builder.CommunityJsonMapper;
import java.beans.PropertyEditor;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
@RequestMapping(value={"/community-admin"})
public class CommunityController {
    @Autowired
    private CommunityService communityService;

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        ObjectMapper objectMapper = new ObjectMapper();
        binder.registerCustomEditor(PageParam.class, (PropertyEditor)new PageParamObjectMapper(objectMapper));
    }

    @GetMapping(value={"/communities"}, headers={"Content-type=application/json"})
    public ResponseEntity<Page<CommunityJson>> findCommunities(@RequestParam(required=true, name="pageParam") PageParam pageParam, @RequestParam(required=false, name="sortParam") SortParam sortParam, @RequestHeader(value="User-Agent") String userAgent) {
        Sort sort = Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)"name"), Sort.Order.desc((String)"shortName")});
        CommunityFilter communityFilter = new CommunityFilter();
        PageRequest pageRequest = pageParam.toPageRequest(sort);
        Page communities = this.communityService.findCommunities(communityFilter, (Pageable)pageRequest).map(CommunityJsonMapper::map);
        return ResponseEntity.ok((Object)communities);
    }

    @GetMapping(value={"/community/{communityId}"}, headers={"Content-type=application/json"})
    public ResponseEntity<CommunityJson> findCommunity(@PathVariable(value="communityId") Long communityId, @RequestHeader(value="betofficeToken") String token, @RequestHeader(value="User-Agent") String userAgent) {
        return ResponseEntity.ok((Object)CommunityJsonMapper.map(this.communityService.find(communityId)));
    }

    @PostMapping(value={"/community"}, headers={"Content-type=application/json"})
    public ResponseEntity<CommunityJson> createCommunity(@RequestBody CommunityJson communityJson, @RequestHeader(value="betofficeToken") String token, @RequestHeader(value="User-Agent") String userAgent) {
        PartyJson communityManager = communityJson.getCommunityManager();
        SeasonJson season = communityJson.getSeason();
        String name = communityJson.getName();
        String shortName = communityJson.getShortName();
        String year = communityJson.getYear();
        CommunityReference communityReference = CommunityReference.of((String)shortName);
        SeasonReference seasonReference = SeasonReference.of((String)season.getYear(), (String)season.getName());
        Nickname nickname = Nickname.of((String)communityManager.getNickname());
        ServiceResult betofficeServiceResult = this.communityService.create(communityReference, seasonReference, name, year, nickname);
        Optional<CommunityJson> community = betofficeServiceResult.result().map(CommunityJsonMapper::map);
        return community.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.badRequest().build());
    }

    @PutMapping(value={"/community"}, headers={"Content-type=application/json"})
    public ResponseEntity<CommunityJson> updateCommunity(@RequestBody CommunityJson communityJson, @RequestHeader(value="betofficeToken") String token, @RequestHeader(value="User-Agent") String userAgent) {
        return null;
    }

    @DeleteMapping(value={"/community"}, headers={"Content-type=application/json"})
    public ResponseEntity<CommunityJson> deleteCommunity(@RequestBody CommunityJson communityJson, @RequestHeader(value="betofficeToken") String token, @RequestHeader(value="User-Agent") String userAgent) {
        return null;
    }
}

