/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.web.auth;

import de.betoffice.service.SecurityToken;
import de.betoffice.web.auth.AuthenticationForm;
import de.betoffice.web.auth.BetofficeAuthenticationService;
import de.betoffice.web.auth.LogoutFormData;
import de.betoffice.web.json.PingJson;
import de.betoffice.web.json.SecurityTokenJson;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.time.ZonedDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
@RequestMapping(value={"/authentication"})
public class AuthenticationController {
    private final BetofficeAuthenticationService betofficeAuthenticationService;

    @Autowired
    public AuthenticationController(BetofficeAuthenticationService authenticationService) {
        this.betofficeAuthenticationService = authenticationService;
    }

    @RequestMapping(value={"/ping"}, method={RequestMethod.GET})
    public PingJson ping() {
        PingJson pingJson = new PingJson();
        pingJson.setDateTime(ZonedDateTime.now());
        return pingJson;
    }

    @PostMapping(value={"/login"}, headers={"Content-type=application/json"})
    public ResponseEntity<SecurityTokenJson> login(@RequestBody AuthenticationForm authenticationForm, @RequestHeader(required=false, name="User-Agent", defaultValue="User-Agent-Unknown") String userAgent, HttpServletRequest request) {
        SecurityTokenJson securityToken = this.betofficeAuthenticationService.login(authenticationForm.getNickname(), authenticationForm.getPassword(), request.getSession().getId(), request.getRemoteAddr(), userAgent);
        HttpSession session = request.getSession();
        session.setAttribute(SecurityToken.class.getName(), (Object)securityToken);
        return ResponseEntity.ok((Object)securityToken);
    }

    @PostMapping(value={"/logout"})
    public SecurityTokenJson logout(@RequestBody LogoutFormData logoutFormData, @RequestHeader(required=false, name="Authorization") String authorization, HttpServletRequest request) {
        SecurityTokenJson securityTokenJson = this.betofficeAuthenticationService.logout(logoutFormData.getNickname(), logoutFormData.getToken());
        HttpSession session = request.getSession();
        session.removeAttribute(SecurityToken.class.getName());
        session.invalidate();
        SecurityContextHolder.clearContext();
        new SecurityContextLogoutHandler().logout(request, null, null);
        return securityTokenJson;
    }
}

