/*
 * Decompiled with CFR 0.152.
 */
package de.betoffice.openligadb;

import de.betoffice.openligadb.DateTimeService;
import de.betoffice.openligadb.json.OLDBMatch;
import de.betoffice.openligadb.json.OLDBMatchResult;
import de.betoffice.storage.season.entity.Game;
import de.betoffice.storage.season.entity.GameResult;
import de.betoffice.storage.team.entity.Team;
import java.time.ZonedDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OpenligadbToBetofficeBuilder {
    private final DateTimeService dateTimeService;

    @Autowired
    public OpenligadbToBetofficeBuilder(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public Game buildGame(OLDBMatch match, Team boHomeTeam, Team boGuestTeam) {
        Game boMatch = new Game();
        ZonedDateTime zdt = this.dateTimeService.toDate(match.getMatchDateTime());
        boMatch.setDateTime(zdt);
        boMatch.setHomeTeam(boHomeTeam);
        boMatch.setGuestTeam(boGuestTeam);
        return boMatch;
    }

    public Game updateGameDate(Game game, OLDBMatch match) {
        game.setDateTime(this.dateTimeService.toDate(match.getMatchDateTime()));
        return game;
    }

    public Game updateGameResult(Game game, OLDBMatch matchData) {
        game.setPlayed(matchData.getMatchIsFinished().booleanValue());
        List<OLDBMatchResult> matchResults = matchData.getMatchResults();
        for (OLDBMatchResult matchResult : matchResults) {
            GameResult result = GameResult.of((int)matchResult.getPointsTeam1(), (int)matchResult.getPointsTeam2());
            switch (matchResult.getResultTypeID()) {
                case 1: {
                    game.setHalfTimeGoals(result);
                    break;
                }
                case 2: {
                    game.setResult(result);
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    game.setOverTimeGoals(result);
                    game.setKo(true);
                    break;
                }
                case 5: {
                    game.setPenaltyGoals(result);
                    game.setKo(true);
                    break;
                }
            }
        }
        return game;
    }
}

