/*
 * Decompiled with CFR 0.152.
 */
package de.dbload.misc;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public class NumberUtils {
    public static final String DEFAULT_DECIMAL_FORMAT = "###,###.##";
    public static final String DEFAULT_ZERO_FORMAT = "##,##0.00";
    private static final Locale DEFAULT_LOCALE = Locale.getDefault();

    public static Number toNumber(String value) {
        return NumberUtils.toNumber(value, DEFAULT_LOCALE);
    }

    public static Number toNumber(String value, Locale locale) {
        return NumberUtils.toNumber(value, NumberUtils.createDecimalFormatter(locale));
    }

    public static Number toNumber(String value, DecimalFormat decimalFormat) {
        Number number;
        try {
            number = NumberUtils.parseNumber(value, decimalFormat);
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
        return number;
    }

    private static Number parseNumber(String value, DecimalFormat decimalFormat) throws ParseException {
        return decimalFormat.parse(value);
    }

    public static DecimalFormat createDecimalFormatter(Locale locale) {
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance(locale);
        decimalFormat.applyPattern(DEFAULT_DECIMAL_FORMAT);
        return decimalFormat;
    }
}

