/*
 * Decompiled with CFR 0.152.
 */
package de.dbload.misc;

import java.sql.Timestamp;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;

public class DateTimeUtils {
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String ORACLE_DATE_FORMAT = "yyyy-MM-dd HH24:MI:ss";
    private static DateTimeFormatter DEFAULT_FORMATTER_FOR_JODA_DATETIME = new DateTimeFormatterBuilder().appendYear(4, 4).appendLiteral("-").appendMonthOfYear(2).appendLiteral("-").appendDayOfMonth(2).appendLiteral(" ").appendHourOfDay(2).appendLiteral(":").appendMinuteOfHour(2).appendLiteral(":").appendSecondOfMinute(2).toFormatter();

    public static DateTime toJodaDateTime(String dateAsString) {
        DateTime dateTime = DateTime.parse((String)dateAsString, (DateTimeFormatter)DEFAULT_FORMATTER_FOR_JODA_DATETIME);
        return dateTime;
    }

    public static DateTime toDateJodaTime(Timestamp timestamp) {
        Date date = new Date(timestamp.getTime());
        return new DateTime((Object)date);
    }

    public static long toLong(DateTime datetime) {
        return datetime.toDate().getTime();
    }

    public static Timestamp toTimestamp(DateTime datetime) {
        return new Timestamp(datetime.toDate().getTime());
    }
}

