/*
 * Decompiled with CFR 0.152.
 */
package de.dbload.meta;

public class ColumnMetaData {
    private final String columnName;
    private final Type columnType;

    public ColumnMetaData(String columnName, Type columnType) {
        this.columnName = columnName;
        this.columnType = columnType;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Type getColumnType() {
        return this.columnType;
    }

    public String toString() {
        return this.columnName + "[" + (Object)((Object)this.columnType) + "]";
    }

    public static enum Type {
        VARCHAR(12),
        BIT(-7),
        LONG(-5),
        INTEGER(4),
        DECIMAL(3),
        DATE(91),
        TIME(92),
        DATE_TIME(93);

        private int javaSqlType;

        private Type(int type) {
            this.javaSqlType = type;
        }

        public int getJavaSqlType() {
            return this.javaSqlType;
        }

        public static Type valueOf(int javaSqlType) {
            for (Type type : Type.values()) {
                if (type.getJavaSqlType() != javaSqlType) continue;
                return type;
            }
            throw new IllegalStateException("Unknown column type found: '" + javaSqlType + "'");
        }
    }
}

