/*
 * Decompiled with CFR 0.152.
 */
package de.dbload.jdbc.connector;

import de.dbload.impl.DbloadException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class JdbcConnector {
    public static Connection createConnection(String databaseUrl) {
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(databaseUrl);
            conn.setAutoCommit(false);
        }
        catch (SQLException ex) {
            throw new DbloadException(String.format("Unable to connect to database with url=[%s].", databaseUrl), ex);
        }
        return conn;
    }

    public static Connection createConnection(String user, String password, String databaseUrl) {
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(databaseUrl, user, password);
            conn.setAutoCommit(false);
        }
        catch (SQLException ex) {
            throw new DbloadException(String.format("Unable to connect to database with url=[%s], user=[%s], password=[%s]", databaseUrl, user, password), ex);
        }
        return conn;
    }
}

