/*
 * Decompiled with CFR 0.152.
 */
package de.dbload.jdbc;

import de.dbload.meta.ColumnMetaData;
import de.dbload.meta.ColumnsMetaData;

class SqlStatementBuilderUtils {
    SqlStatementBuilderUtils() {
    }

    public static String createColumnDescription(ColumnsMetaData columns) {
        SqlStatementBuilderUtils.checkArguments(columns);
        return SqlStatementBuilderUtils.joinColumns(columns, new ColumnNameIterator()).toString();
    }

    public static String createQuestionMarkPerColumn(ColumnsMetaData columns) {
        SqlStatementBuilderUtils.checkArguments(columns);
        return SqlStatementBuilderUtils.joinColumns(columns, new QuestionMarkIterator()).toString();
    }

    public static String createAndCondition(ColumnsMetaData columns) {
        boolean first = true;
        StringBuilder andCondition = new StringBuilder();
        for (ColumnMetaData columnMetaData : columns) {
            if (!first) {
                andCondition.append("AND ");
            }
            andCondition.append(columnMetaData.getColumnName()).append(" = ? ");
            first = false;
        }
        return andCondition.toString().trim();
    }

    private static void checkArguments(ColumnsMetaData columns) {
        if (columns == null || columns.size() == 0) {
            throw new IllegalArgumentException("columns is null or empty");
        }
    }

    private static StringBuilder joinColumns(ColumnsMetaData columns, ColumnIterator columnIterator) {
        boolean first = true;
        StringBuilder insertSqlCommand = new StringBuilder();
        for (ColumnMetaData column : columns) {
            if (!first) {
                insertSqlCommand.append(", ");
            }
            insertSqlCommand.append(columnIterator.get(column));
            first = false;
        }
        return insertSqlCommand;
    }

    private static class QuestionMarkIterator
    implements ColumnIterator {
        private QuestionMarkIterator() {
        }

        @Override
        public String get(ColumnMetaData column) {
            if (column.getColumnType().equals((Object)ColumnMetaData.Type.BIT)) {
                return "?";
            }
            return "?";
        }
    }

    private static class ColumnNameIterator
    implements ColumnIterator {
        private ColumnNameIterator() {
        }

        @Override
        public String get(ColumnMetaData column) {
            return column.getColumnName();
        }
    }

    private static interface ColumnIterator {
        public String get(ColumnMetaData var1);
    }
}

