/*
 * Decompiled with CFR 0.152.
 */
package de.dbload.jdbc;

import de.dbload.DbloadContext;
import de.dbload.jdbc.AbstractPreparedSqlStatement;
import de.dbload.jdbc.PreparedStatementBuilder;
import de.dbload.jdbc.SqlSelectStatementBuilder;
import de.dbload.meta.DataRow;
import de.dbload.meta.TableMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreparedSqlSelectStatement
extends AbstractPreparedSqlStatement {
    private static final Logger LOG = LoggerFactory.getLogger(PreparedSqlSelectStatement.class);
    private boolean preparedStatementReturnsWithResultSet;
    private ResultSet resultSet;

    public PreparedSqlSelectStatement(DbloadContext _context, TableMetaData _tableMetaData) throws SQLException {
        super(_context, _tableMetaData, PreparedStatementBuilder.prepareStatement(_context, new SqlSelectStatementBuilder(_tableMetaData)));
    }

    @Override
    public void execute(DataRow data) throws SQLException {
        this.applyParams(data);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing \n\t[{}] with data \n\t[{}]", (Object)this.getPreparedStatement(), (Object)data);
        }
        this.preparedStatementReturnsWithResultSet = this.getPreparedStatement().execute();
        this.resultSet = this.getPreparedStatement().getResultSet();
    }

    @Override
    public boolean hasResultSet() {
        return this.preparedStatementReturnsWithResultSet;
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }
}

