/*
 * Decompiled with CFR 0.152.
 */
package de.dbload.jdbc;

import de.dbload.JdbcTypeConverter;
import de.dbload.meta.ColumnMetaData;
import de.dbload.misc.DateTimeUtils;
import de.dbload.misc.NumberUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;

public class DefaultJdbcTypeConverter
implements JdbcTypeConverter {
    private static final Integer ONE = 1;
    private static final Integer ZERO = 0;
    private static final String NULL = "NULL";
    private DecimalFormat decimalFormat;

    public DefaultJdbcTypeConverter() {
        this.decimalFormat = NumberUtils.createDecimalFormatter(Locale.getDefault());
    }

    public DefaultJdbcTypeConverter(Locale locale) {
        this.decimalFormat = NumberUtils.createDecimalFormatter(locale);
    }

    public DefaultJdbcTypeConverter(DecimalFormat _decimalFormat) {
        this.decimalFormat = _decimalFormat;
    }

    @Override
    public Object convert(ColumnMetaData columnMetaData, String value) {
        Object returnValue = null;
        block0 : switch (columnMetaData.getColumnType()) {
            case VARCHAR: {
                returnValue = value;
                break;
            }
            case BIT: {
                if (value == null) {
                    returnValue = ZERO;
                    break;
                }
                switch (value) {
                    case "J": {
                        returnValue = ONE;
                        break block0;
                    }
                    case "Y": {
                        returnValue = ONE;
                        break block0;
                    }
                    case "1": {
                        returnValue = ONE;
                        break block0;
                    }
                    case "0": {
                        returnValue = ZERO;
                        break block0;
                    }
                    case "": {
                        returnValue = ZERO;
                        break block0;
                    }
                    case "NULL": {
                        returnValue = ZERO;
                        break block0;
                    }
                    case "null": {
                        returnValue = ZERO;
                        break block0;
                    }
                }
                returnValue = ZERO;
                break;
            }
            case TIME: 
            case DATE: 
            case DATE_TIME: {
                if (value == null) break;
                DateTime jodaDateTime = DateTimeUtils.toJodaDateTime(value);
                java.util.Date date = jodaDateTime.toDate();
                long dateAsLong = date.getTime();
                returnValue = new Timestamp(dateAsLong);
                break;
            }
            case DECIMAL: 
            case INTEGER: {
                if (value == null) break;
                if (StringUtils.equalsIgnoreCase((String)value, (String)NULL)) {
                    returnValue = null;
                    break;
                }
                returnValue = NumberUtils.toNumber(value, this.decimalFormat);
                break;
            }
            case LONG: {
                if (value == null) break;
                if (StringUtils.equalsIgnoreCase((String)value, (String)NULL)) {
                    returnValue = null;
                    break;
                }
                returnValue = NumberUtils.toNumber(value, this.decimalFormat);
                break;
            }
            default: {
                returnValue = value;
            }
        }
        return returnValue;
    }

    @Override
    public void setTypedValue(PreparedStatement stmt, int index, ColumnMetaData columnMetaData, Object value) throws SQLException {
        switch (columnMetaData.getColumnType()) {
            case VARCHAR: {
                if (value == null) {
                    stmt.setNull(index, 12);
                    break;
                }
                stmt.setString(index, value.toString());
                break;
            }
            case BIT: {
                if (value == null) {
                    stmt.setNull(index, -7);
                    break;
                }
                stmt.setInt(index, (Integer)value);
                break;
            }
            case DECIMAL: {
                if (value == null) {
                    stmt.setNull(index, 3);
                    break;
                }
                if (value instanceof Float) {
                    stmt.setFloat(index, ((Float)value).floatValue());
                    break;
                }
                if (value instanceof Double) {
                    stmt.setDouble(index, (Double)value);
                    break;
                }
                if (value instanceof BigDecimal) {
                    stmt.setBigDecimal(index, (BigDecimal)value);
                    break;
                }
                throw new IllegalStateException("Unknown decimal type " + columnMetaData.getColumnName());
            }
            case INTEGER: 
            case LONG: {
                if (value == null) {
                    stmt.setNull(index, -5);
                    break;
                }
                if (value instanceof Integer) {
                    stmt.setInt(index, (Integer)value);
                    break;
                }
                if (value instanceof Long) {
                    stmt.setLong(index, (Long)value);
                    break;
                }
                if (value instanceof Short) {
                    stmt.setShort(index, (Short)value);
                    break;
                }
                if (value instanceof Byte) {
                    stmt.setByte(index, (Byte)value);
                    break;
                }
                throw new IllegalStateException("Unknown number type " + (Object)((Object)columnMetaData.getColumnType()) + " for object " + value);
            }
            case TIME: 
            case DATE: 
            case DATE_TIME: {
                if (value == null) {
                    stmt.setNull(index, 93);
                    break;
                }
                if (value instanceof String) {
                    java.util.Date date = DateTimeUtils.toJodaDateTime((String)value).toDate();
                    Timestamp sqlDate = new Timestamp(date.getTime());
                    stmt.setTimestamp(index, sqlDate);
                    break;
                }
                if (value instanceof java.util.Date) {
                    Date sqlDate = new Date(((java.util.Date)value).getTime());
                    Timestamp timestamp = new Timestamp(sqlDate.getTime());
                    stmt.setTimestamp(index, timestamp);
                    break;
                }
                throw new IllegalStateException("Unknown decimal type " + columnMetaData.getColumnName());
            }
            default: {
                if (value == null) {
                    stmt.setNull(index, 0);
                    break;
                }
                stmt.setObject(index, value);
            }
        }
    }
}

