/*
 * Decompiled with CFR 0.152.
 */
package de.dbload.jdbc;

import de.dbload.DbloadContext;
import de.dbload.jdbc.JdbcUtils;
import de.dbload.jdbc.PreparedStatementBuilder;
import de.dbload.meta.DataRow;
import de.dbload.meta.TableMetaData;
import java.io.Closeable;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public abstract class AbstractPreparedSqlStatement
implements Closeable {
    private final DbloadContext dbloadContext;
    private final PreparedStatement stmt;
    private final TableMetaData tableMetaData;

    public AbstractPreparedSqlStatement(DbloadContext _context, TableMetaData _tableMetaData, PreparedStatement preparedStatement) throws SQLException {
        this.dbloadContext = _context;
        this.tableMetaData = _tableMetaData;
        this.stmt = preparedStatement;
    }

    @Override
    public void close() {
        JdbcUtils.close(this.stmt);
    }

    public String toString() {
        return this.stmt.toString();
    }

    protected PreparedStatement getPreparedStatement() {
        return this.stmt;
    }

    protected void applyParams(DataRow dataRow) throws SQLException {
        PreparedStatementBuilder.applyParams(dataRow, this.tableMetaData, this.dbloadContext.getJdbcTypeConverter(), this.stmt);
    }

    public abstract void execute(DataRow var1) throws SQLException;

    abstract boolean hasResultSet();
}

