/*
 * Decompiled with CFR 0.152.
 */
package de.dbload.impl;

import de.dbload.DbloadContext;
import de.dbload.csv.reader.ResourceDataReader;
import de.dbload.csv.reader.ResourceReader;
import de.dbload.csv.reader.ResourceReaderCallback;
import de.dbload.csv.writer.ResourceWriter;
import de.dbload.impl.DbloadException;
import de.dbload.impl.DbloadSqlInsert;
import de.dbload.jdbc.JdbcUtils;
import de.dbload.meta.DataRow;
import de.dbload.meta.TableMetaData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDbloadImpl {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDbloadImpl.class);

    public void readFromFile(DbloadContext context, File readFromFile) {
        try {
            FileInputStream is = new FileInputStream(readFromFile);
            this.startReading(is, context);
        }
        catch (FileNotFoundException ex) {
            LOG.error("Dbload throws an error.", (Throwable)ex);
            throw new DbloadException(ex);
        }
    }

    public void readFromClasspathResource(DbloadContext context, Class<?> clazz, String resource) {
        InputStream is = clazz.getResourceAsStream(resource);
        this.startReading(is, context);
    }

    public void readFromClasspathResource(DbloadContext context, Class<?> clazz) {
        InputStream is;
        String classpathResourceName = clazz.getSimpleName() + ".dat";
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading dat file: classpath=[{}], resource=[{}].", (Object)clazz.getName(), (Object)classpathResourceName);
        }
        if ((is = clazz.getResourceAsStream(classpathResourceName)) == null) {
            LOG.error("There is no classpath resource for {}.", (Object)classpathResourceName);
            throw new IllegalArgumentException(classpathResourceName);
        }
        this.startReading(is, context);
    }

    private void startReading(InputStream is, final DbloadContext context) {
        try (ResourceDataReader rdr = new ResourceDataReader(is);){
            final DbloadSqlInsert dbloadSqlInsert = new DbloadSqlInsert(context);
            ResourceReader resourceReader = new ResourceReader();
            resourceReader.start(rdr, new ResourceReaderCallback(){

                @Override
                public void newTableMetaData(TableMetaData tableMetaData) {
                    try {
                        TableMetaData metaData = JdbcUtils.toTableMetaData(JdbcUtils.findMetaData(context.getConnection(), tableMetaData.getTableName()));
                        dbloadSqlInsert.newTableMetaData(metaData);
                    }
                    catch (SQLException ex) {
                        throw new DbloadException(ex);
                    }
                }

                @Override
                public void newDataRow(DataRow dataRow) {
                    try {
                        dbloadSqlInsert.execute(dataRow);
                    }
                    catch (SQLException ex) {
                        String error = "Unable to execute INSERT [" + dbloadSqlInsert.toString() + "] statement with params [" + dataRow + "]";
                        LOG.error(error);
                        throw new DbloadException(error, ex);
                    }
                }
            });
            dbloadSqlInsert.close();
        }
        catch (IOException ex) {
            LOG.error("Dbload throws an error.", (Throwable)ex);
            throw new DbloadException(ex);
        }
    }

    public void writeToFile(DbloadContext context, File writeToFile, String[] tableNames) {
        ArrayList<String> list = new ArrayList<String>();
        for (String tableName : tableNames) {
            list.add(tableName);
        }
        this.writeToFile(context, writeToFile, list);
    }

    public void writeToFile(DbloadContext context, File writeToFile, List<String> tableNames) {
        ResourceWriter rw = new ResourceWriter(writeToFile);
        try {
            for (String tableName : tableNames) {
                String select = String.format("SELECT * FROM %s", tableName);
                rw.start(context.getConnection(), select, true);
            }
        }
        catch (SQLException ex) {
            LOG.error("Unable to write export file!", (Throwable)ex);
            throw new DbloadException(ex);
        }
    }
}

