/*
 * Decompiled with CFR 0.152.
 */
package de.dbload.impl;

import de.dbload.DbloadContext;
import de.dbload.impl.DbloadSqlStatement;
import de.dbload.jdbc.PreparedSqlSelectStatement;
import de.dbload.meta.DataRow;
import de.dbload.meta.TableMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DbloadSqlSelect
implements DbloadSqlStatement {
    private final DbloadContext context;
    private PreparedSqlSelectStatement preparedSqlStatement;
    private int resultRowCounter;

    public DbloadSqlSelect(DbloadContext _context) {
        this.context = _context;
    }

    @Override
    public void newTableMetaData(TableMetaData tableMetaData) throws SQLException {
        if (this.preparedSqlStatement != null) {
            this.preparedSqlStatement.close();
        }
        this.preparedSqlStatement = new PreparedSqlSelectStatement(this.context, tableMetaData);
    }

    @Override
    public void execute(DataRow dataRow) throws SQLException {
        this.preparedSqlStatement.execute(dataRow);
        ResultSet resultSet = this.preparedSqlStatement.getResultSet();
        this.resultRowCounter = 0;
        while (resultSet.next()) {
            ++this.resultRowCounter;
        }
    }

    @Override
    public void close() {
        this.preparedSqlStatement.close();
    }

    public int getResultRowCounter() {
        return this.resultRowCounter;
    }
}

