/*
 * Decompiled with CFR 0.152.
 */
package de.dbload.impl;

import de.dbload.DbloadContext;
import de.dbload.impl.DbloadSqlStatement;
import de.dbload.jdbc.AbstractPreparedSqlStatement;
import de.dbload.jdbc.PreparedSqlInsertStatement;
import de.dbload.meta.DataRow;
import de.dbload.meta.TableMetaData;
import de.dbload.misc.StopWatch;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbloadSqlInsert
implements DbloadSqlStatement {
    private static final Logger LOG = LoggerFactory.getLogger(DbloadSqlInsert.class);
    private final DbloadContext context;
    private final StopWatch stopWatch = new StopWatch();
    private TableMetaData currentTableMetaData;
    private int numberOfRows;
    private AbstractPreparedSqlStatement preparedSqlStatement;

    public DbloadSqlInsert(DbloadContext _context) {
        this.context = _context;
    }

    @Override
    public void newTableMetaData(TableMetaData tableMetaData) throws SQLException {
        this.close();
        this.currentTableMetaData = tableMetaData;
        this.numberOfRows = 0;
        this.stopWatch.start();
        this.preparedSqlStatement = new PreparedSqlInsertStatement(this.context, tableMetaData);
    }

    @Override
    public void execute(DataRow dataRow) throws SQLException {
        this.preparedSqlStatement.execute(dataRow);
        ++this.numberOfRows;
    }

    @Override
    public void close() {
        if (this.preparedSqlStatement != null) {
            this.preparedSqlStatement.close();
            this.stopWatch.stop();
            if (LOG.isInfoEnabled()) {
                LOG.info("DBLOAD stats:  Tablename: {}, Number of rows: {}, Time [ms]: {}", new Object[]{this.currentTableMetaData.getTableName(), this.numberOfRows, this.stopWatch.getTime()});
            }
            this.numberOfRows = 0;
        }
    }

    public String toString() {
        return this.preparedSqlStatement.toString();
    }
}

