/*
 * Decompiled with CFR 0.152.
 */
package de.dbload.impl;

import de.dbload.impl.DbloadSqlStatement;
import de.dbload.meta.ColumnMetaData;
import de.dbload.meta.DataRow;
import de.dbload.meta.TableMetaData;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.lang.StringUtils;

public class DbloadFileInsert
implements DbloadSqlStatement {
    private TableMetaData tableMetaData;
    private File sqlOutputFile;
    private FileOutputStream fos;
    private Writer writer;

    public DbloadFileInsert(File directory, Class<?> clazz) {
        this(directory, clazz.getName());
    }

    public DbloadFileInsert(File directory, String testcase) {
        this.sqlOutputFile = new File(directory, testcase + ".sql");
        if (this.sqlOutputFile.exists()) {
            this.sqlOutputFile.delete();
        }
        try {
            this.fos = new FileOutputStream(this.sqlOutputFile, true);
            this.writer = new OutputStreamWriter((OutputStream)this.fos, "UTF-8");
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public void newTableMetaData(TableMetaData _tableMetaData) {
        this.tableMetaData = _tableMetaData;
        try {
            this.writer.write("\r\n");
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public void execute(DataRow data) {
        StringBuilder insertSqlCommand = new StringBuilder("INSERT INTO ");
        insertSqlCommand.append(this.tableMetaData.getTableName());
        insertSqlCommand.append('(');
        boolean first = true;
        for (ColumnMetaData column : this.tableMetaData.getColumns()) {
            if (!first) {
                insertSqlCommand.append(", ");
            }
            insertSqlCommand.append(column.getColumnName());
            first = false;
        }
        insertSqlCommand.append(")\r\n VALUES (");
        first = true;
        for (ColumnMetaData column : this.tableMetaData.getColumns()) {
            String val;
            if (!first) {
                insertSqlCommand.append(", ");
            }
            String insertme = column.getColumnType() == ColumnMetaData.Type.DATE ? "to_date('" + data.get(column.getColumnName()) + "', '" + "yyyy-MM-dd HH24:MI:ss" + "')" : (StringUtils.isBlank((String)(val = data.get(column.getColumnName()))) ? "NULL" : "'" + val + "'");
            first = false;
            insertSqlCommand.append((Object)insertme);
        }
        insertSqlCommand.append(");");
        try {
            this.writer.write(insertSqlCommand.toString());
            this.writer.write("\r\n");
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public void close() {
        try {
            if (this.writer != null) {
                this.writer.close();
            }
            if (this.fos != null) {
                this.fos.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

