/*
 * Decompiled with CFR 0.152.
 */
package de.dbload.csv.writer;

import de.dbload.impl.DbloadException;
import de.dbload.meta.ColumnMetaData;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import org.joda.time.DateTime;

public class ResourceWriter {
    private final File file;
    private final Charset utf8;

    public ResourceWriter(Path _path) {
        this(_path.toFile());
    }

    public ResourceWriter(File _file) {
        this.file = _file;
        this.utf8 = Charset.forName("UTF-8");
    }

    public void start(Connection conn, String sqlSelect, boolean append) throws SQLException {
        if (append) {
            if (!this.file.exists()) {
                try {
                    this.file.createNewFile();
                }
                catch (IOException ex) {
                    throw new DbloadException("Unable to create export file.", ex);
                }
            }
        } else if (this.file.exists()) {
            this.file.delete();
        }
        try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(this.file.toPath(), append ? StandardOpenOption.APPEND : StandardOpenOption.CREATE));
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, this.utf8);){
            PrintWriter pw = new PrintWriter((Writer)writer, true);
            try (Statement stmt = conn.createStatement();
                 ResultSet resultSet = stmt.executeQuery(sqlSelect);){
                int i;
                ResultSetMetaData metaData = resultSet.getMetaData();
                pw.print("### TAB ");
                pw.println(metaData.getTableName(1));
                pw.print("### ");
                for (i = 1; i <= metaData.getColumnCount(); ++i) {
                    pw.print(metaData.getColumnName(i));
                    if (i >= metaData.getColumnCount()) continue;
                    pw.print(" | ");
                }
                pw.println();
                while (resultSet.next()) {
                    for (i = 1; i <= metaData.getColumnCount(); ++i) {
                        String print = null;
                        int type = resultSet.getMetaData().getColumnType(i);
                        ColumnMetaData.Type columnType = ColumnMetaData.Type.valueOf(type);
                        switch (columnType) {
                            case DATE: 
                            case TIME: 
                            case DATE_TIME: {
                                Timestamp timestamp = resultSet.getTimestamp(i);
                                if (timestamp == null) {
                                    print = "";
                                    break;
                                }
                                Date date = new Date(timestamp.getTime());
                                DateTime dateTime = new DateTime((Object)date);
                                print = dateTime.toString("yyyy-MM-dd HH:mm:ss");
                                break;
                            }
                            default: {
                                print = resultSet.getString(i);
                            }
                        }
                        pw.print(print);
                        if (i >= metaData.getColumnCount()) continue;
                        pw.print(" | ");
                    }
                    pw.println();
                }
                pw.println();
            }
        }
        catch (IOException ex) {
            throw new DbloadException(ex);
        }
    }
}

