/*
 * Decompiled with CFR 0.152.
 */
package de.dbload.csv.reader;

import de.dbload.csv.reader.ColumnTypeParser;
import de.dbload.csv.reader.ResourceDataReader;
import de.dbload.csv.reader.ResourceParser;
import de.dbload.csv.reader.ResourceReaderCallback;
import de.dbload.meta.ColumnsMetaData;
import de.dbload.meta.DataRow;
import de.dbload.meta.TableMetaData;
import java.io.IOException;
import java.util.List;

public class ResourceReader {
    public void start(ResourceDataReader resourceDataReader, ResourceReaderCallback resourceReaderCallback) throws IOException {
        resourceDataReader.open();
        ResourceParser resourceParser = new ResourceParser();
        String currentTableName = null;
        TableMetaData currentTableMetaData = null;
        int lineNo = 1;
        String line = null;
        do {
            line = resourceDataReader.readLine();
            switch (resourceParser.parse(lineNo, line)) {
                case COLUMN_DEFINITION: {
                    if (currentTableName == null) {
                        throw new IllegalStateException("Find column description without a table name!");
                    }
                    List<String> currentColumnNames = resourceParser.readColumnNames(line);
                    ColumnsMetaData columnsMetaData = ColumnTypeParser.parseColumnsMetaData(currentColumnNames);
                    currentTableMetaData = new TableMetaData(currentTableName, columnsMetaData);
                    resourceReaderCallback.newTableMetaData(currentTableMetaData);
                    break;
                }
                case COMMENT_OR_EMPTY: {
                    break;
                }
                case DATA_DEFINITION: {
                    DataRow dataRow = resourceParser.readRow(currentTableMetaData.getColumns().getColumnNames(), lineNo, line);
                    resourceReaderCallback.newDataRow(dataRow);
                    break;
                }
                case TABLE_DEFINITION: {
                    currentTableName = resourceParser.readTableDefinition(line);
                    break;
                }
            }
            ++lineNo;
        } while (!resourceDataReader.endOfFile());
    }
}

