/*
 * Decompiled with CFR 0.152.
 */
package de.dbload.csv.reader;

import de.dbload.meta.DataRow;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;

public class ResourceParser {
    private String tableName;
    private List<String> columns;
    private DataRow data;
    private ParserState parserState;

    public String getTableName() {
        return this.tableName;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public DataRow getDataRow() {
        return this.data;
    }

    public ParserState parse(int lineNo, String line) {
        String currentLine = StringUtils.trimToEmpty((String)line);
        if (currentLine.startsWith("### TAB")) {
            this.tableName = this.readTableDefinition(line);
            this.parserState = ParserState.TABLE_DEFINITION;
        } else if (currentLine.startsWith("###")) {
            this.columns = this.readColumnNames(line);
            this.parserState = ParserState.COLUMN_DEFINITION;
        } else if (currentLine.length() > 0 && currentLine.charAt(0) == '#' || StringUtils.isBlank((String)currentLine)) {
            this.parserState = ParserState.COMMENT_OR_EMPTY;
        } else if (!StringUtils.isBlank((String)currentLine)) {
            this.readRow(this.columns, lineNo, line);
            this.parserState = ParserState.DATA_DEFINITION;
        }
        return this.parserState;
    }

    public DataRow readRow(List<String> _columns, int _lineNo, String line) {
        this.data = new DataRow();
        StringTokenizer stok = new StringTokenizer(line, "|", true);
        boolean lastTokenIsDelim = false;
        int index = 0;
        while (stok.hasMoreTokens()) {
            String token = stok.nextToken();
            if (StringUtils.equals((String)"|", (String)token)) {
                if (lastTokenIsDelim) {
                    if (index >= _columns.size()) {
                        throw new IllegalStateException("More data than columns!");
                    }
                    this.data.put(_columns.get(index++), null);
                }
                lastTokenIsDelim = true;
                continue;
            }
            if (index >= _columns.size()) {
                this.throwIllegalColumnSizeException(_lineNo, line);
            }
            this.data.put(_columns.get(index++), token == null ? null : StringUtils.trimToNull((String)token));
            lastTokenIsDelim = false;
        }
        if (lastTokenIsDelim) {
            if (index >= _columns.size()) {
                this.throwIllegalColumnSizeException(_lineNo, line);
            }
            this.data.put(_columns.get(index), null);
        }
        return this.data;
    }

    private void throwIllegalColumnSizeException(int _lineNo, String line) {
        throw new IllegalStateException("More data than columns! Check line nr " + _lineNo + " with data [" + line + "]");
    }

    public List<String> readColumnNames(String columnDefinition) {
        ArrayList<String> _columns = new ArrayList<String>();
        String tmp = columnDefinition.trim();
        if (!tmp.startsWith("###")) {
            throw new IllegalStateException("Expected ###");
        }
        tmp = StringUtils.removeStart((String)tmp, (String)"###");
        StringTokenizer stok = new StringTokenizer(tmp, "|");
        while (stok.hasMoreTokens()) {
            String token = stok.nextToken();
            _columns.add(token.trim());
        }
        return _columns;
    }

    public String readTableDefinition(String tableDefinition) {
        String token;
        String _tableName = "";
        StringTokenizer stok = new StringTokenizer(tableDefinition);
        if (stok.hasMoreTokens() && !StringUtils.equals((String)(token = stok.nextToken()), (String)"###")) {
            throw new IllegalStateException("Expected ###");
        }
        if (stok.hasMoreTokens() && !StringUtils.equals((String)(token = stok.nextToken()), (String)"TAB")) {
            throw new IllegalStateException("Expected TAB");
        }
        if (stok.hasMoreTokens()) {
            token = stok.nextToken();
            if (StringUtils.isBlank((String)token)) {
                throw new IllegalStateException();
            }
            _tableName = token;
        }
        return _tableName;
    }

    public static enum ParserState {
        TABLE_DEFINITION,
        COLUMN_DEFINITION,
        DATA_DEFINITION,
        COMMENT_OR_EMPTY;

    }
}

