/*
 * Decompiled with CFR 0.152.
 */
package de.dbload.csv.reader;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class ResourceDataReader
implements Closeable {
    private InputStream resourceAsStream;
    private InputStreamReader inputStreamReader;
    private BufferedReader bufferedReader;
    private String line;

    public ResourceDataReader(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalStateException("The inputStream is not defined.");
        }
        this.resourceAsStream = inputStream;
    }

    public void open() throws IOException {
        if (this.resourceAsStream == null) {
            throw new IllegalStateException("The inputStream is not defined.");
        }
        this.inputStreamReader = new InputStreamReader(this.resourceAsStream, "UTF-8");
        this.bufferedReader = new BufferedReader(this.inputStreamReader);
    }

    public String readLine() throws IOException {
        this.line = this.bufferedReader.readLine();
        return this.line;
    }

    public boolean endOfFile() {
        return null == this.line;
    }

    @Override
    public void close() {
        if (this.bufferedReader != null) {
            try {
                this.bufferedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.inputStreamReader != null) {
            try {
                this.inputStreamReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.resourceAsStream != null) {
            try {
                this.resourceAsStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

