/*
 * Decompiled with CFR 0.152.
 */
package de.dbload.csv.reader;

import de.dbload.meta.ColumnMetaData;
import de.dbload.meta.ColumnsMetaData;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ColumnTypeParser {
    public static ColumnsMetaData parseColumnsMetaData(List<String> columnNames) {
        ColumnsMetaData columnsMetaData = new ColumnsMetaData();
        for (String columnNameAndType : columnNames) {
            columnsMetaData.addColumn(ColumnTypeParser.parseColumnMetaData(columnNameAndType));
        }
        return columnsMetaData;
    }

    public static ColumnMetaData parseColumnMetaData(String columnNameAndType) {
        ColumnMetaData.Type columnType = ColumnTypeParser.findType(columnNameAndType);
        String normalizedColumnName = StringUtils.substringBefore((String)columnNameAndType, (String)"(").trim();
        return new ColumnMetaData(normalizedColumnName, columnType);
    }

    protected static ColumnMetaData.Type findType(String columnDescription) {
        if (ColumnTypeParser.containsDate(columnDescription)) {
            return ColumnMetaData.Type.DATE_TIME;
        }
        if (ColumnTypeParser.containsBit(columnDescription)) {
            return ColumnMetaData.Type.BIT;
        }
        return ColumnMetaData.Type.VARCHAR;
    }

    protected static boolean containsDate(String string) {
        return StringUtils.containsIgnoreCase((String)string, (String)"(date)");
    }

    protected static boolean containsBit(String string) {
        return StringUtils.containsIgnoreCase((String)string, (String)"(bit)");
    }
}

