/*
 * Decompiled with CFR 0.152.
 */
package de.dbload.assertion;

import java.util.ArrayList;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.AllOf;
import org.hamcrest.core.IsEqual;

public class MapContentMatchers<T, V>
extends TypeSafeMatcher<Map<? super T, ? super V>> {
    private final T key;
    private final Matcher<V> valueMatcher;

    MapContentMatchers(T key, V value) {
        this(key, IsEqual.equalTo(value));
    }

    MapContentMatchers(T key, Matcher<V> valueMatcher) {
        this.key = key;
        this.valueMatcher = valueMatcher;
    }

    public boolean matchesSafely(Map<? super T, ? super V> item) {
        return item.containsKey(this.key) && this.valueMatcher.matches(item.get(this.key));
    }

    public void describeTo(Description description) {
        description.appendText("an entry with key ").appendValue(this.key).appendText(" and value matching ").appendDescriptionOf(this.valueMatcher);
    }

    @Factory
    public static <T, V> Matcher<Map<? super T, ? super V>> hasEntry(T key, V value) {
        return new MapContentMatchers<T, V>(key, value);
    }

    @Factory
    public static <T, V> Matcher<Map<? super T, ? super V>> hasEntry(T key, Matcher<V> valueMatcher) {
        return new MapContentMatchers<T, V>(key, valueMatcher);
    }

    @Factory
    public static <T, V> Matcher<Map<? super T, ? super V>> hasKey(T key) {
        return new MapContentMatchers<T, V>(key, CoreMatchers.anything((String)"any Value"));
    }

    @Factory
    public static <T, V> Matcher<Map<? super T, ? super V>> hasAllEntries(Map<T, V> entries) {
        ArrayList<Matcher<Map<T, V>>> matchers = new ArrayList<Matcher<Map<T, V>>>(entries.size());
        for (Map.Entry<T, V> entry : entries.entrySet()) {
            V value = entry.getValue();
            if (value instanceof Matcher) {
                matchers.add(MapContentMatchers.hasEntry(entry.getKey(), (Matcher)value));
                continue;
            }
            matchers.add(MapContentMatchers.hasEntry(entry.getKey(), value));
        }
        return new AllOf(matchers);
    }
}

