/*
 * Decompiled with CFR 0.152.
 */
package de.dbload.assertion;

import de.dbload.DbloadContext;
import de.dbload.assertion.DbloadAssertionContext;
import de.dbload.csv.reader.ResourceDataReader;
import de.dbload.csv.reader.ResourceReader;
import de.dbload.csv.reader.ResourceReaderCallback;
import de.dbload.impl.DbloadException;
import de.dbload.jdbc.PreparedStatementBuilder;
import de.dbload.jdbc.SqlSelectStatementBuilder;
import de.dbload.meta.DataRow;
import de.dbload.meta.TableMetaData;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

public class Assertion {
    private Assertion() {
    }

    public static void assertExists(final DbloadContext context, Class<?> clazz) {
        InputStream is = clazz.getResourceAsStream(clazz.getSimpleName() + ".dat");
        try (ResourceDataReader rdr = new ResourceDataReader(is);){
            final TableMetaDataHolder tableMetaDataHolder = new TableMetaDataHolder();
            ResourceReader resourceReader = new ResourceReader();
            resourceReader.start(rdr, new ResourceReaderCallback(){

                @Override
                public void newTableMetaData(TableMetaData _tableMetaData) {
                    tableMetaDataHolder.setValue(_tableMetaData);
                }

                @Override
                public void newDataRow(DataRow dataRow) {
                    try {
                        Assertion.assertExists(context, tableMetaDataHolder.getValue(), dataRow);
                    }
                    catch (SQLException ex) {
                        throw new DbloadException(ex);
                    }
                }
            });
        }
        catch (IOException ex) {
            throw new DbloadException(ex);
        }
    }

    public static boolean assertExists(DbloadContext _context, TableMetaData _tableMetaData, List<DataRow> _dataRow) throws SQLException {
        SqlSelectStatementBuilder sqlSelectStatement = new SqlSelectStatementBuilder(_tableMetaData);
        PreparedStatement stmt = PreparedStatementBuilder.prepareStatement(_context, sqlSelectStatement);
        DbloadAssertionContext assertionContext = new DbloadAssertionContext(_context, _tableMetaData, stmt);
        boolean ok = true;
        for (DataRow dataRow : _dataRow) {
            ok = ok && assertionContext.assertExists(dataRow);
        }
        return ok;
    }

    public static boolean assertExists(DbloadContext _context, TableMetaData _tableMetaData, DataRow _dataRow) throws SQLException {
        SqlSelectStatementBuilder sqlSelectStatement = new SqlSelectStatementBuilder(_tableMetaData);
        PreparedStatement stmt = PreparedStatementBuilder.prepareStatement(_context, sqlSelectStatement);
        DbloadAssertionContext assertionContext = new DbloadAssertionContext(_context, _tableMetaData, stmt);
        return assertionContext.assertExists(_dataRow);
    }

    private static class TableMetaDataHolder {
        private TableMetaData tableMetaData;

        private TableMetaDataHolder() {
        }

        public void setValue(TableMetaData _tableMetaData) {
            this.tableMetaData = _tableMetaData;
        }

        public TableMetaData getValue() {
            return this.tableMetaData;
        }
    }
}

